---
title: "Analyse d'impact - une opportunité pour les graphes"
date: 2022-04-06
categories: 
  - "plm"
coverImage: "2022-04-06-11.22.57-2-edited-e1649238186131.jpg"
---

## [Obsodays](https://www.isae-supmeca.fr/2nd-obso-days/)

Je participe depuis hier aux [Obsodays](https://www.isae-supmeca.fr/2nd-obso-days/), organisés par l'ISAE Supmeca dans les locaux d'Alstom Villeurbanne. Cela me ramène à certaines de mes premières activités d'ingénierie lorsque je créais des bases de gestion d'obsolescence à la SAGEM (Safran Electronics).

[![](images/2022-04-05-13.21.57-1024x462.jpg)](https://plm-ouvert.fr/wp-content/uploads/2022/04/2022-04-05-13.21.57-scaled.jpg)

L'obsolescence portant majoritairement sur des produits contenant de l'électronique, la conférence rappelle que le périmètre de surveillance des obsolescences est bien plus large.

[![](images/2022-04-06-11.22.57-2-edited.jpg)](https://plm-ouvert.fr/wp-content/uploads/2022/04/2022-04-06-11.22.57-2-scaled.jpg)

Airbus présente pour sa part les problématiques d'obsolesence des logiciels qui supportent tout le cycle de vie d'un avion et nécessitent d'être maintenus sur toute la durée de vie d'un avion.

[![](images/2022-04-05-14.53.47-1024x462.jpg)](https://plm-ouvert.fr/wp-content/uploads/2022/04/2022-04-05-14.53.47-scaled.jpg)

## Analyse d'impact

La question des analyses d'impact dans la gestion d'obsolescence est omniprésente. Et cela tombe bien car c'est exactement le type de questions sur lesquelles nous nous sommes penchés récemment avec un de nos clients. [Vous pouvez voir notre article en anglais sur PLM Stack](https://plmstack.com/2022/04/05/graph-and-cypher-for-a-typical-plm-question/). Nous avions déjà présenté [l'avantage du langage de requete cypher pour de telles analyse](https://ganister.eu/blog/cypher-versus-sql?lang=en). Les bases de données graphes révèlent une vraie puissance de recherche d'impact avec une agilité à répondre à des analyses très spécifiques.

## Requêter l'inconnu

Une des puissances du graphe est la capacité à requêter des données sans connaitre leurs relations, voir même leurs types. Lorsqu'on procède à une analyse d'impact, il faut habituellement connaitre toutes les relations possibles pour récupérer une analyse exhaustive. Avec une base graphe on va pouvoir rechercher des impacts sans forcément maitriser la totalité du chemin.

Dans le graphe suivant, sans voir la données sous forme de graphe, les personnes consommant cette données ne sont pas forcément au courant de l'existence de liens comme "Project Validated Parts" ou "Maintenance Parts".

[![](images/image-1024x444.png)](https://plm-ouvert.fr/wp-content/uploads/2022/04/image.png)

```
MATCH path=(:family{_ref:"XXX"})-[*]->(:part) RETURN path
```

La requête ci-dessus permet de retourner tous les chemins possibles entre la famille XXX et des articles, quelque soit le type de relations et d'objets traversés et quelque soit la longueur du chemin.

La requête est simple à lire, et la technologie des graphes indexant les relations sur chaque nœud permet des performances inégalables sur de telles récupérations de données.

On a l'habitude de voir des analyses d'impact entre des produits et leurs composants. Avec l'augmentation de la complexité des produits, demain il faudra être capable de l'analyse d'impact en prenant en compte les contraintes légales, la capitalisation des savoirs, etc.

Le sujet est passionnant, si vous avez de telles problématiques, que quelqu'un dans votre entreprise passe beaucoup de temps à rechercher des données liées dans un contexte d'obsolescence ou autre, n'hésitez pas à me contacter.
