---
title: "La course au PLM multi-tenant !"
date: 2021-08-23
categories: 
  - "cloud"
  - "plm"
coverImage: "1.png"
---

Avant d'aborder ce sujet, Je souhaite à toutes les personnes qui reviennent de vacances, une bonne reprise. Cela fait plus d'un an que je n'avais pas publié d'article sur ce blog PLM francophone. Très largement lié à mon investissement sur la nouvelle société [Ganister PLM](https://ganister.eu/) dans laquelle nous vivons actuellement une superbe aventure avec les différentes personnes qui nous rejoignent et nos partenaires.

Back to Business, en effet le "PLM Multi-tenant" est une très forte demande aujourd'hui. Les directions informatiques relayées par les éditeurs qui essaient de prendre un leadership sur le sujet veulent du "click'n play". Ce besoin n'est pas nouveau. Avec l'arrivée de la virtualisation, du cloud, des offres SaaS, l'accès facilité aux logiciels fait fantasmer les uns (industriels) pour sa facilité d'accès et les autres (les éditeurs) pour l'illusion d'une croissance commerciale exponentielle. Quelles sont les raisons d'un possible retard des solutions SaaS PLM?

## C'est quoi le multi-tenant

Avant tout qu'est-ce que le muti-tenant? C'est purement technique car derrière vous pouvez avoir accès à deux solutions SaaS sans vous rendre compte que l'une est multi-tenant et l'autre ne l'est pas. Pour faire simple on qualifie une solution de multi-tenant lorsque vous pouvez être plusieurs sociétés sur un même serveur. Le logiciel doit alors savoir gérer la ségrégation des données et parfois des configurations différentes tout en hébergeant la solution sur un seul et même serveur. L'automatisation de processus de déploiement permet de donner parfois l'illusion d'un multi-tenant et il n'y a pas de mal à cela.

## Challenge technique du PLM multi-tenant

Le principal challenge technique pour le PLM (et je ne parle pas de PDM) c'est de trouver un modèle métier qui convienne à tout le monde. Et pour l'instant personne ne l'a vraiment trouvé. Certains verticaux métiers permettent de remplir un besoin plus large avec des fonctions de base. Mais on sait que chaque projet PLM reste encore hyper spécifique. Chaque projet PLM étant souvent un remplacement d'une constellation de fichiers legacy. Donc gérer plusieurs modèles de données créant des données hétérogènes dans une même base de données parait un peu compliqué.

## L'opportunité d'une base de données commune

L'an dernier des sondages (je n'en retrouve pas les sources, il faudra me croire sur ce coup!) sur les besoins des industriels en matière de PLM montraient que les fonctionnalités principales attendues tournaient autour de la supply-chain. Sûrement influencé par la crise du covid c'est en effet un besoin qui s'exprime de plus en plus. L'idée d'avoir une base de données commune, si la ségrégation des données est bien gérée, permettrait plus de collaboration entre différentes entreprises qui pourraient partager des portions de données dans le cadre de projets.

## Les graphes

Je vais prêcher pour ma paroisse, mais il est vrai que les bases de données graphes sont sûrement les seules bases de données qui permettraient cette hétérogénéité de modèles métiers tout en permettant la collaboration. Le plus simple pour les éditeurs serait de trouver un modèle commun avec un besoin de customisation le plus réduits possible, mais ça reste aujourd'hui le combat de seuls quelques Don Quichote ou de projets dédiés à de très grandes entreprises.

## Conclusion

Faire du PLM multi-tenant est un challenge hyper excitant qui risque de nous (éditeurs) faire passer beaucoup de temps sur nos tableaux blancs. Cependant si votre besoin est d'avoir une solution flexible sans avoir à gérer un serveur, votre besoin n'est pas forcément un PLM multi-tenant. Les éditeurs PLM savent déjà proposer leurs solutions en un mode "SaaS", le côté multi-tenant ne doit pas trop vous concerner. Enfin si vous pensez que le multi-tenant va considérablement faire baisser le coût de la mise en place d'une solution PLM, il est possible que vous soyez déçu. Les migrations de données, la gestion du changement, etc... représente des postes de coûts très importants et ne seront pas trop impacté par le passage au multi-tenant.
