---
title: "EDCH #4 : Interchangeabilité et pièces de rechange"
date: 2019-08-28
categories: 
  - "librairie"
  - "plm"
coverImage: "2019-08-28-10.42.51.jpg"
---

Me voici de retour pour la suite des aventures de l'ouvrage Engineering Documentation Control Handbook, pour lequel j'avoue avoir perdu un peu d'intérêt ces derniers temps compte tenu des premiers chapitres qui ne tranchaient pas suffisamment sur les bonnes pratiques à adopter.

Enfin ce chapitre sur l'interchangeabilité et les pièces de rechange est en fait à 90% sur la question de l'interchangeabilité et de la gestion de l'information autour de cette problématique. C'est d'ailleurs un sujet sur lequel j'avais été plusieurs fois à écrire à contre courant de la pensée générale qui voulait souvent qu'on définisse des interchangeabilité pour limiter des remontée d'indices dans des structures produits.

## Interchangeabilité

Definition du National Trade Magazine:

> ... a part number key must be unique, reflecting a part's form fit, or function. If any of these change, even a little bit, then a different part number must be assigned to maintain integrity.
> 
> national trade magazine

L'auteur Frank B Watts, n'est pas d'accord avec cette définition parce que pour lui le "even a little bit" laisse trop de place à l'argumentation. Alors que pas du tout, c'est justement très clair dans cette définition (qu'on soit d'accord avec elle ou non) que la moindre modification du form fit ou function résulte en un changement de code article.

Il va donc essayer par des exemples de montrer que dans de nombreux cas, il est pratique d'appliquer l'interchangeabilité alors que les similarités entre deux versions d'un produits sont criantes.

## Il va falloir devenir sérieux !

A travers mes experiences chez des clients, j'ai eu une multitude d'exemple de gestion d'équivalence et d'interchangeabilité qui me faisaient dire "ok oui, dans ce cas je comprends". Mais à chaque fois les interchangeabilité se passaient dans des contexte connus à un instant T. Notre but, pour nous les consultant du PLM, c'est quand même de tendre vers un standard général et je ne peux pas architecturer un système de gestion PLM (je ne parle pas de logiciel, le système regroupant, une structuration de données, des process et des oui, des outils pour les supporter ensuite) qui soit différent pour chaque client.

Je ne suis pas contre l'interchangeabilité entre deux articles quand FFF est maintenu en apparence. Cependant, il y a une obligation de tracer cette interchangeabilité pour maîtriser le contexte de cette interchangeabilité. Je reprend souvent l'exemple d'une industrie qui réalise des moteurs pour des application loin de la mer et de toute agression saline. Le jour où ils commencent à vendre des moteurs qui seront installés sur des navires, le contexte d'étude d'interchangeabilité évolue et doit pouvoir remettre en cause les décisions passées.

**L'interchangeabilité est et doit rester contextuelle.**

L'auteur présente ensuite dans son ouvrage différents exemples d'interchangeabilité. Et il y a encore un point sur lequel je ne suis pas forcément d'accord. C'est la remise en cause d'une spécification produit implicitement validée par l'usage d'une première version d'un produit, je m'explique. Vous vendez un train avec une specification faite sur le poids, la vitesse et la hauteur. Le client est content il fabrique une infrastructure autour de ce train avec des quais par exemple. Vous modifiez votre train avec une marche d'accès 10 cm plus basses. Vous n'avez jamais spécifié ce point et le vendez comme interchangeable comme ça n'impact pas le FFF spécifié. Merci les quais...

## Un doute sur l'interchangeabilité d'un article?

L'auteur ne s'étale pas trop sur la question des pièces de rechange mais il termine au moins son article avec une remarque que je confirme:

> When in doubt, change part number !
> 
> Frank B. Watts

### Prochain article

Le prochain chapitre que je traiterai portera sur la nomenclature. J'essaierai d'ailleurs de faire un article complémentaire sur la nomenclature avec le témoignage d'Oleg Shilovitsky d'Open BOM.
