---
title: "Les 7 raisons de GitLab pour faire de l'intégration continue"
date: 2016-12-23
categories: 
  - "integration-continue"
  - "plm"
  - "techniques_logicielles"
coverImage: "gitlabMain.png"
---

Il y a quelques temps [j'avais transcrit un entretien avec Damien Destrez, architecte chez Minerva (un intégrateur de la solution PLM Aras Innovator) sur le sujet de l'intégration continue](http://plm-ouvert.fr/2016/05/integration-continue-pour-plm-lexemple-de-minerva-pour-aras-innovator/). Ils s'appuient en partie sur la solution GitLab qui permet de gérer leurs sources et aussi de réaliser l'intégration continue d'instance Aras Innovator.

![gitlab lifecycle](images/GitlabLifecycle.png)

Récemment Gitlab a publié [un article de Blog que je voulais reprendre ici en français](https://about.gitlab.com/2015/02/03/7-reasons-why-you-should-be-using-ci/):

## Les 7 raisons de Gitlab pour faire de l'intégration continue

### Réalisez vos tests dans le monde réel

L'intégration continue va permettre de déployer des instances sur des environnements représentatifs de l'environnement cible et potentiellement vierges pour s'assurer que le fonctionnement en local n'était pas dû à une librairie non gérée.

### Augmentez la couverture de test

Les KPIs de couvertures de test permettent d'indiquer à chaque commit d'un développeur, l'évolution de la couverture de test. Si ce KPI baisse après un commit, c'est que le développeur a intégré moins de test avec son code que le niveau de test sur le reste de l'application.

### Déployez votre code en production

Un process complet de commit, de validation, de test, le tout géré par les outils d'intégration continue vous permettra de déployer vos évolutions en production.

### "Buildez" votre code directement

Comme toutes les tâches administratives de manipulation d'outils sans valeur ajoutée sont automatisées, vous n'avez plus qu'à suivre un voyant qui devient vert lorsque la chaine de "build" est finalisée.

### "Buildez" votre code plus rapidement

Les outils d'intégration continue comme Gitlab offrent de plus en plus de capacité de process parallèles pour assurer une exécution rapide des "Build". Est-ce que la composante temps est si critique que cela dans un contexte PLM?

### Ne détruisez plus vos développement

L'intégration des tests est capitale dans l'utilisation d'une telle solution. L'automatisation fait souvent peur à priori car elle fait penser que le contrôle risque d'être réduit alors que c'est justement l'inverse. L'intégration continue permet de réduire le temps passé sur des opérations sans valeur ajoutée pour muscler au contraire la partie test et validation.

### Réduisez le temps de revue de code

Les interfaces de comparaison de code entre deux versions et toute la partie collaborative en ligne (chat, notifications) permettent d’accélérer la revue de code et de la faire plus fréquemment pour des portions de code/configuration plus réduites.

## Ma raison principale: du temps et surtout de la qualité !

Encore une fois, pour la majorité des personnes impliquées dans des discussions PLM, ce sujet est poussé vers les experts techniques dans le meilleur des cas, ou juste ignoré. C'est pourtant capital dès le début du projet pour tester la compétence de votre intégrateur. L'éditeur ne peut en général pas être votre intégrateur et vous devez évaluer les intégrateurs potentiels. Celui qui ne sait pas répondre correctement à la problématique d'intégration continue, vous présenter son process, ses outils et démontrer que le tout marche par une démonstration, ne peut pas sérieusement déployer une solution PLM chez vous.

L'intégration continue fait gagner du temps, et par son automatisation on pense que la vitesse est sa qualité principale. Mais, faites des intégrations à la main et vous verrez vite que c'est la qualité par la répétabilité qui offre la plus grande valeur.

Bon réveillon de Noël pour ceux qui le fêtent !
