---
title: "Pourquoi un modèle de données quand on me propose la liberté avec des noeuds et des liens?"
date: 2016-10-11
categories: 
  - "bdd"
  - "plm"
  - "techniques_logicielles"
coverImage: "LOD_Cloud_2014.svg_.png"
---

Récemment j'ai rencontré des entreprises qui ne voulaient pas de modèle de données pré-défini dans leur futur système, ils veulent pouvoir intégrer n'importe quel objet avec n'importe quel typage de lien entre ces objets. La logique et la forme des structures manipulées seraient réalisées par les outils d'authoring (CAO,...).

C'est génial ! juste des noeuds et des liens, plus de contrainte de comment bien modéliser son système d'information!

Hop hop hop ! ça parait un peu trop beau pour être une bonne solution.

## Quelle est l'origine du besoin?

Sur l'origine du besoin, j'aimerais bien avoir l'input de plusieurs architectes SI, ou responsables SI qui auraient été tentés par cette option. J'ai croisé plusieurs projets ces derniers mois où l'on me demandait de mettre cela en place.

Mon analyse est que la diversité des objets est telle, que les directions IT n'ont pas envie d'avoir un outil qui en plus d'être neutre (s'interfaçant avec des outils d'authoring divers) doit être architecturé en dur pour intégrer le modèle de données des objets envoyés par les outils d'authoring.

L'équivalent dans le web serait de dire : "on ne va pas demander à tout le monde d'écrire en anglais et en plus d'utiliser les mêmes mots pour décrire les mêmes choses !". Sauf que là, nous ne sommes pas sur le web et vous n'allez pas recréer un moteur de recherche sémantique pour le besoin spécifique de votre entreprise!

Je comprends bien l'inquiétude, mais il faut faire ce travail d'achitecturer le système central et sûrement de manière différente de vos données d'authoring (donc conversion, donc craintes de perte en ligne... J'ai pas dit que c'était simple).

## Pourquoi un modèle de données?

Le modèle de données a plusieurs raisons d'être.

C'est avant tout un dictionnaire. C'est lui qui vous indique comment on décrit un objet particulier. Donc, si demain votre outil d'authoring décide de changer de format en changeant le nom de document à article ou d'article à part, Comment allez vous gérer cela si vous laissez tout rentrer?

C'est ensuite une logique de liens, qui va déterminer votre capacité à naviguer entre des objets et surtout des logiques business. Là, c'est plus compliqué à illustrer mais c'est beaucoup plus impactant. Ce n'est pas seulement de la donnée plus compliquée à retrouver, c'est des logiques métiers potentiellement erronées impactant l'intégrité de votre base de connaissance.

## Graph database vs SQL vs NoSQL?

J'en ai fait moi même la pub, et je continue à le faire pour certaines applications complexes, les bases graphiques facilitent grandement des analyses complexes telles que réalisées dans le cadre de gestion de configuration (analyse d'impact systèmes complexes).

Mais le problème ne vient pas des bases graphiques. Au final, même si sur une première approche on se dit que c'est génial avec des bases graphiques et des bases NoSql de pouvoir saisir des données sans schéma, on s'aperçoit rapidement en développant des applications que le schéma de la base de données s'impose pour une question de cohérence. Base graphique, NoSql ou SQL, il sera toujours raisonnable d'avoir une couche pour contraindre un modèle de données.

Si vous voulez comparer les bases de données (comparaison technologiques, je vous suggère l'article d'Oleg à ce sujet : "[TECH SOFT 3D TECHTALK: PLM AND DATA MANAGEMENT IN 21ST CENTURY](http://beyondplm.com/2013/10/25/tech-soft-3d-techtalk-plm-and-data-management-in-21st-century/)"

## Conclusion

NON aux sacs de nœuds ! Ils nous sont de plus en plus demandés aussi pour des questions de gestion de configuration où l'on veut que tout type d'objet puisse rentrer dans ces processus. Mais c'est un problème distinct. Donc, ne vous cristallisez pas sur cette architecture "miracle", gardez du bon sens et architecturez vos solutions PLM !
