---
title: "Simplexité - prenons le dessus sur la complexité ambiante"
date: 2016-05-08
categories: 
  - "ingesystem"
  - "plm"
coverImage: "maxresdefault.jpg"
---

Je souhaitais faire un billet depuis quelque temps sur le concept de "Simplexité" et un article de l'Usine Digitale m'a poussé à sauter le pas.

Vous vous rappelez peut être du poste sur le "système thinking": ["Complexité", à ne pas confondre avec le compliqué](http://plm-ouvert.fr/2015/12/system-thinking-savoir-etre-nouveau-savoir-penser/).

[Wikipedia](https://fr.wikipedia.org/wiki/Simplexit%C3%A9) donne une introduction très alléchante du concept de "Simplexité":

> La simplexité est une notion émergente d'ingénierie et des neurosciences sur l'"art de rendre simple, lisible, compréhensible les choses complexes".
> 
> De même que "complexe" ne doit pas être confondu avec "compliqué", "simplexe" ne doit pas être confondu avec "simple".
> 
> Une "chose simplexe" est une "chose complexe dont on a déconstruit la complexité que l'on sait expliquer de manière simple".
> 
> Rendre "simplexe un objet artificiel" est un "processus d'ingénierie complexe consistant à rendre simple et épuré un ensemble puissant de fonctionnalités"

Voici donc un [article de l'Usine Digitale](http://www.usine-digitale.fr/article/la-simplexite-ou-comment-bien-vivre-avec-la-complexite-plutot-que-de-la-combattre.N389204) sur la Simplexité et qui interroge [Angela Minzoni](http://www.lgi.ecp.fr/pmwiki.php/PagesPerso/AMinzoniDesroche). La scientifique vient de publier le livre "_Faisons Simplexe de A à Z_".

J'en tire quelques citations qui m'ont plu:

> **Concrètement, quels effets auraient sur l’entreprise l’adoption des notions liés à la simplexité ?** Les relations seraient plus plates, avec davantage de zones d’autonomie pour les individus et une place plus grande laissée à l’auto-régulation. Avec la simplexité, on évite les cascades hiérarchiques, la multiplication des délégations.
> 
> **Si je vous comprends bien, plus on lutte contre la complexité, plus on crée de complications ?** C’est le cercle vicieux qu’il faut éviter à tout prix. Face à une situation où on constate une forme de complexité, une personne va décider qu’il faut simplifier. Pour cela, elle va découper encore plus les tâches, elle va vouloir standardiser, standardiser. Toutes ces démarches créent_in fine_ des complications, alors qu’elles prétendaient faire le contraire.
> 
> **Pourquoi est-ce aussi important ?** Il faut donner aux individus les moyens de comprendre ce qu’ils font et pourquoi ils le font, si on veut qu’ils vivent bien avec la complexité. Ainsi, ils auront une vision précise de leur travail, de sons sens, mais aussi de la manière dont il a un impact sur celui des autres, ce qui est aussi essentiel.

C'est article est me semble-t-il très intéressant:

- Il me permet personnellement de remettre en question quelques certitudes comme celles de "diviser pour mieux gérer la complexité",
- Je comprends désormais mieux ce qu'est la simplexité et comment l'appliquer,
- J'y vois des références aux problématiques d'hyper-spécialisation dans le monde du travail, où nous ne donnons plus à l'ingénieur la possibilité de replacer les tâches qui lui sont allouées dans un contexte plus global,
- J'y vois enfin le besoin de fournir des outils; certainement informatiques; pour permettre aux ingénieurs de naviguer seul, en pleine autonomie, dans la complexité et pour mieux appréhender son travail dans la globalité de l'organisation.

Ce concept de simplexité est peut être l'étape qui vient après la prise en compte de la complexité ambiante. Une fois que votre organisation aura compris qu'elle évolue dans une monde complexe et qu'il faut s'organiser en conséquence, peut être alors viendra le moment de tenter d'appréhender la simplexité?

N'hésitez pas à nous faire partager vos idées sur ce concept. Ceci afin que nous allions plus loin dans la réflexion.
