---
title: "Sommes-nous dépassés par la complexité de nos systèmes de transports ?"
date: 2016-02-25
categories: 
  - "ingesystem"
  - "plm"
coverImage: "U.S._Atlantic_Seaboard_at_Night.jpg"
---

Pour faire écho au poste de Rida Messaoudi sur la complexité grandissante des systèmes :

En parcourant le web, je suis tombé sur cette étude de Science Advances : « _[Lost in transportation: Information measures and cognitive limits in multilayer navigation](http://advances.sciencemag.org/content/2/2/e1500445.full)_ » ou _Sommes-nous dépassés par la complexité de nos systèmes de transports ?_

Je me suis dit qu’il serait intéressant de la partager avec vous puisqu’elle soutient l’objectif de mes billets, à savoir « _comment appréhender la complexité ambiante_ » ;

# Traduction de l’introduction de l’étude.

> _Les villes et leurs systèmes de transports deviennent de plus en plus complexes et multimodaux à mesure qu’ils grandissent, et il est naturel de se demander s’il est possible de quantifier nos difficultés croissantes à y naviguer et si la navigation au sein de ces systèmes excède nos limites cognitives. Différentes stratégies pour naviguer au sein des cartes métropolitaines ont été observées pour de grands et complexes réseaux métropolitains. Il en ressort une évidence : il existe une limite associée à la surcharge cognitive et causée par un trop grand nombre d’information à considérer pour décider. A la lumière de ces résultats, nous avons analysé les 15 plus grands réseaux métropolitains au monde  et nous avons estimé que la limite d’information pour déterminer un trajet dans un système de transport doit être de l’ordre de 8 bits. \[…\] nos limites cognitives suggère qu’une carte ne devraient pas contenir plus de 250 connections pour être aisément lisible. Nous avons également démontré qu’inclure les connections avec d’autres moyens de transport augmentait dramatiquement le nombre d’informations nécessaires pour naviguer dans un réseau de transport multicouches. Dans des villes comme New-York, Paris et Tokyo, plus de 80% des trajets sont supérieurs à la limite des 8 bits. Ainsi les systèmes de transport multimodaux ont déjà dépassé les limites cognitives humaines, et par conséquent, la manière de visualiser et naviguer dans nos systèmes de transport dans les villes doit être sensiblement revisitée._

On comprend qu’il faille s’armer d’outils puissants pour pouvoir analyser les  systèmes de transport et améliorer leur utilisation. Un outil comme le _[Design Structure Matrix](http://plm-ouvert.fr/2016/01/design-structure-matrix-introduction/)_ permettrait par exemple de faire apparaître les nœuds critiques.

D’autres outils de visualisation disponibles en open source + les données open source du gouvernement permettent désormais de réaliser des [cartes à moindre coût](http://www.ekseerg.com/playing/metro/fullscreen.html). On imagine (et on espère) que nos dirigeants sont également équipés d’outils similaires.

### **Pour en revenir à l’ingénierie système**

Cela rejoint des questionnements que j’ai souvent entendus de la part de personnes expérimentées  du milieu industriel: « _pourquoi est-il désormais nécessaire d’appliquer ces méthodologies d’ingénierie système (gestion des exigences, traçabilité, ingénierie par les modèles, et collaboration entre ingénieurs au travers d’outils) alors que moi à l’époque je parvenais à développer un calculateur de commandes de vol presque seul sans ces méthodologies ? »._ Je pense que la réponse est la même que pour les systèmes de transports : une complexité croissante qui dépasse désormais les limites cognitives de nos meilleurs ingénieurs.

Et ce n’est pas anodin car ce dépassement de nos capacités cognitives individuelles a créé un effet de complexité boule de neige : pour gérer cette complexité, il a fallu demander à toujours davantage de capacités cognitives (d’hommes) de travailler ensemble, de se coordonner. Et la tâche est loin d'être aisée.

Je pense que vous le comprenez : Pour gérer nos systèmes à la complexité croissante, nous sommes obligés d’appliquer un management de plus en plus complexe qui possède ses propres risques inhérents. Un système dans un système en quelque sorte.

Il en résulte une complexité exponentielle, un monde qui devient de plus en plus difficile à appréhender.
