---
title: "Matrice de Conformité - Un outil recommandé pour son excellent rapport simplicité/puissance"
date: 2016-01-14
categories: 
  - "ingesystem"
tags: 
  - "conformite"
coverImage: "matriceconformité.png"
---

Bonjour,

Aujourd'hui, je souhaite vous faire partager un outil simple et efficace pour la gestion contractuelle avec vos fournisseurs mais surtout pour le pilotage de vos systèmes: **la matrice de conformité**. Vous la retrouverez parfois sous l'appellation _liste de déviations_, _matrice de non-conformités_, etc. Je préfère l'approche positive qui rappelle également l'objectif final qui est d'être conforme.

[Vous vous rappelez](http://plm-ouvert.fr/2015/12/lingenierie-systeme-quest-ce-cest-pourquoi/) qu'en ingénierie système, on suit généralement le cycle de développement en V. Vous vous rappelez également que l'ingénierie système est le chef d'orchestre de plusieurs sous-champs d'ingénierie, ou bien de plusieurs sous-composants qui mis en commun réalisent le système. C'est bien la conformité des composants au besoin spécifié qui mis en commun vont assurer la conformité du système.

Je n'ai pas encore abordé la façon dont l'ingénierie système gérait le contrat entre client et fournisseur. C'est au travers des exigences que nous aborderons plus tard. J'espère que des intervenants (comme [Joseph Aracic](https://fr.linkedin.com/in/joseph-aracic-44233b1) que j'invite à écrire) sur ce sujet pourront nous accompagner. J'ai écrit des milliers d'exigences par le passé mais je ne me considère pas comme un expert. Il me reste encore quelques zones d'ombre à éclaircir. Je vais donc devoir ici sauter une étape importante sur le pourquoi et comment faut-il bien écrire des exigences? N'hésitez pas à nous signifier si vous êtes perdus à cause de cela.

Lorsque vous écrivez une exigence au niveau sous-système ou composant, vous définissez ce que ce dernier doit réaliser pour qu'un besoin au niveau système soit réalisé. Vous le comprenez également au travers de ce dessin, si le composant 1 ne respecte pas une de ces exigences, il pourrait impacter plus ou moins fortement un besoin système au travers du sous-système 1 (le plus ou moins dépendant de sa contribution à l'exigence système, nous reverrons cela dans un futur billet).

![Système sous systèmes composants](images/Système-sous-systèmes-composants.png)

La matrice de conformité est un simple outil collaboratif qui:

- demande à votre fournisseur, en regard de chaque exigence que vous lui avez spécifié, de répondre s'il est conforme, en déviation ou non-conforme,
- vous demande en retour, en tant que client, si vous acceptez ou non la non-conformité ou la déviation.

Pourquoi cet outil est-il puissant?

### Votre organisation a déjà atteint un certain degré de maturité en ingénierie système

Si vous êtes capable d'utiliser la matrice de conformité, cela sous-entend que votre organisation est en mesure d'écrire des exigences, elle a donc atteint à minima la première phase de maturité de l'ingénierie système. Cela n'indique pas la qualité de vos exigences, mais cela indique qu'elles ont à minima des identifiants uniques, et vous êtes en mesure de partager un besoin formel/contractuel à vos fournisseurs.

Si vous ne l'êtes pas, vous savez ce qu'il vous reste à faire pour pouvoir initier une démarche efficace sur vos développements et l'aspect contractuel avec vos fournisseurs...

### Vous allez pouvoir bénéficier d'une collaboration efficace avec votre fournisseur

Vos fournisseurs vont vous retourner des non-conformités ou des déviations. Et c'est là que cela devient intéressant! Quelles peuvent-être les raisons de ces non-conformités? Quelques exemples:

1. Le fournisseur n'a pas compris l'exigence, vous devez donc apporter davantage de précisions ou la réécrire,
2. Le fournisseur vous demande de retravailler l'exigence pour que le besoin soit mieux/bien compris par les deux parties,
3. Le fournisseur souhaite vous proposer une alternative, une innovation, ou bien une solution qui comme vous lui avez indiqué (n'est-ce pas? vous n'avez pas oublié au moins!), permettrait de réduire la facture finale en diminuant légèrement les performances ou le comportement. Peut-être serait-ce acceptable pour vous ?
4. Le fournisseur de ne peut tout simplement pas atteindre l'exigence spécifiée et vous le fait savoir. Peut-être y-a-t-il des contraintes technologiques insolubles? ou bien des ruptures sont-elles nécessaires qui n'ont pas encore atteint le niveau de maturité suffisant? ou bien la technologie nécessaire n'est pas en adéquation avec le coût demandé? Toujours est-il qu'il va falloir gérer cette non-conformité ou déviation. Généralement vous aurez deux options: soit revoir les prétentions du système et donc réduire les prétentions du composant qui deviendra alors normalement conforme, soit reporter une partie du besoin sur un autre sous-système ou composant qui aurait lui la possibilité de répondre au besoin.

### Vous allez réellement piloter votre développement

Logique me direz-vous? Mais j'ai vu beaucoup (trop!) d'entreprises qui _libèrent_ une spécification au fournisseur et attendent le résultat des tests de vérification, donc la fin du cycle en V avant de gérer la non-conformité! Comme [nous l'avons vu ici](http://plm-ouvert.fr/2015/12/lingenierie-systeme-quest-ce-cest-pourquoi/#Courbe-Des-Risques), les coûts pour retravailler les non-conformités à la fin du cycle de développement sont aberrants. Alors pourquoi attendre la fin du développement pour prendre en main son développement?

Vous allez donc piloter la conformité de vos composants et sous-systèmes à la spécification émise, dans le temps:

[![Screen Shot 01-09-16 at 02.41 PM](images/Screen-Shot-01-09-16-at-02.41-PM.png)](http://plm-ouvert.fr/wp-content/uploads/2016/01/Screen-Shot-01-09-16-at-02.41-PM.png)

Dans un prochain article j'aborderais le point assez spécifique et difficile de la gestion des performances sur un système complexe. Nous verrons comment suivre les performances au travers des modèles. Un début de réflexion, avec la prise de photo à l'instant T (mise ici en évidence en rouge) d'une performance pilotée:

[![Suivi conformité](images/Suivi-conformité-1.png)](http://plm-ouvert.fr/wp-content/uploads/2016/01/Suivi-conformité-1.png)

### Conclusion

Vous l'avez donc compris, je l'espère, la matrice de conformité offre des avantages que vous n'aviez peut-être pas saisis immédiatement. La matrice de conformité vous amène à discuter vos exigences, elle vous amène à les retravailler, à les affiner pour parvenir à un compromis, elle vous permet d'avoir des exigences claires et comprises par les deux parties (c'est vital!), enfin elle vous permet d'intégrer de l'innovation fournisseur dans votre produit (point non négligeable!).

**Attention, l'outil n'est pas magique!** Ces bénéfices collaboratifs ne peuvent vous apparaître que si vous avez effectivement offert cette opportunité à vos fournisseurs. Le contrat à initier avec vos clients n'est pas seulement unidirectionnel client=>fournisseurs; vous vous devez de créer un climat de confiance, d'échanges qui vous assurera d'avoir des fournisseurs force de proposition et créateurs d'innovation.

Si vous avez été assez courageux pour aller au bout de cet article, alors n'hésitez pas à récupérer ce [template Excel de matrice de conformité](http://www.seintelligence.fr/content/images/2016/01/Compliance Matrix SEI.zip).

Au plaisir de lire vos commentaires pour compléter ou corriger cet article.
