---
title: "\"API-Driven\" PLM"
date: 2015-12-17
categories: 
  - "plm"
  - "techniques_logicielles"
coverImage: "apidrivenplmaudit.png"
---

Toujours à la recherche des meilleures méthodologies d'implémentation de solutions IT et particulièrement sur la partie PLM, j'ai réfléchi à l'opportunité proposée par la croissance exponentielle de l'usage des API. Vous avez pu voir dans ma démonstration de [sailsjs](http://sailsjs.org/) qu'il devenait très facile de mettre en place des services web avec l'infrastructure sécurisée et l'intégration aux systèmes d'entreprise. Alors je propose maintenant à travers mon activité de conseil une méthodologie d'implémentation de solution PLM que j'appelle "API-Driven".

Le processus se focalise sur les services. Et propose une implémentation avec les étapes suivantes:

| ![1450281693_top_chart_track_number_one](images/1450281693_top_chart_track_number_one.png) |  ![1450151275_vector_396_18](images/1450151275_vector_396_18.png) |   ### Audit des services nécessaires   |
| --- | --- | --- |
|  ![1450281713_track_number_two_circle](images/1450281713_track_number_two_circle.png) |  ![1450151598_vector_396_22](images/1450151598_vector_396_22.png) |   ### Sélection de la plateforme   |
|  ![1450281715_three_top_chart_track](images/1450281715_three_top_chart_track.png) |  ![1450150626_vector_396_23](images/1450150626_vector_396_23.png) |   ### Développement   |
|  ![1450281711_top_number_four_track_chart_circle](images/1450281711_top_number_four_track_chart_circle.png) |  ![1450151303_vector_396_05](images/1450151303_vector_396_05.png) |   ### Déploiement   |

Cette démarche se veut indépendante des logiciels au lancement. La dépendance ne vient qu'après la sélection de la plate-forme qui se fait en cohérence avec l'historique de l'IT de l'entreprise sa vision long terme et ses ressources en interne. La valeur de la démarche est surtout dans l'approche en se concentrant sur le besoin réel des utilisateurs. Les services énumérés et spécifiés ensuite sont de divers types:

- Les personnes avec telle responsabilité ont besoin d'enregistrer un fichier
- Un utilisateur doit recevoir un email lorsque le fichier dont il est le responsable a été validé par la qualité
- Un utilisateur doit recevoir un message sur une solution de messagerie (slack) lorsqu'il y a une question sur l'article dont il est responsable
- Un utilisateur doit pouvoir voir la différence entre deux fichiers.

On est sur du basique mais c'est bien à cela que j'aime ramener mes interlocuteurs. Revenons au besoin brut, mettons de côté les particularités techniques, les contraintes logicielles, mettons en place des services, nous construirons ensuite les interfaces pour pouvoir les utiliser.

[Retrouvez l'offre de mydatalinx à ce sujet : "API-Driven" PLM](http://mydatalinx.com/fr/conseil-fr/api-driven-plm.html)
