---
title: "les 7 conseils de zero-wait-state pour selectionner une solution PLM"
date: 2015-08-26
categories: 
  - "plm"
coverImage: "zerowaitstate7tips.png"
---

Au mois de juillet, l'intégrateur de solutions PLM [ZeroWait State](http://zerowait-state.com/) a publié un article sur son blog (blog en anglais que je conseille vivement), listant 7 conseils pour la sélection d'une solution PLM. Je me permets de reprendre les grandes lignes de ces conseils pour les commenter avec mes expériences de sélections et d'implémentations de solutions PLM.

## Prévoir le futur

C'est un des conseils qui s'applique différemment selon le niveau de hiérarchie du décideur dans son entreprise ou selon la taille de l'entreprise. Il m'est arrivé de nombreuses fois de rencontrer des personnes qui ont apparemment été sensibilisées au fait que le PLM pouvait leur apporter de la valeur, mais lorsqu'il fallait choisir une solution technique, les considérations du court terme prenaient le dessus. La technologie évolue énormément ces temps-ci, les plate formes d'utilisations se multiplient, internet n'a pas fini de modifier nos façons de collaborer, il est donc important de se poser la question de ce que sera le PLM pour vous dans au moins 5 ans. Et **la question à se poser est moins "Comment on fera ça avec la solution choisie?", mais plus "Comment la solution permettrait de prendre en compte telle évolution de notre business?".**

## Trouver une solution qui s'implémente par étapes

J'ai croisé un certain nombre d'entreprises avec des projets abandonnées (la plupart du temps c'était sur la partie ERP, pour le PLM et la GED on voit plutôt une réduction importante du périmètre lorsque l'implémentation ne correspond pas aux attentes) pour lesquels la taille initiale du projet d'implémentation était trop importante. Il faut donc pouvoir réaliser une implémentation par étapes et celle-ci demande que la solution soit capable techniquement de le réaliser, mais il faut aussi que le modèle économique soit assez flexible pour permettre d'évoluer avec votre implémentation.

## Prenez bien en compte les customisations

Sur ce point, il est important de ne pas s’arrêter à tout ce qui est dit sur les risques de la customisation de solutions. La customisation a l'avantage en général d'amener un outil à se rapprocher d'un process existant, mais a l'inconvénient d'être un risque. Je dis bien un risque et non un blocage ou autre catastrophe. C'est un risque qui va dépendre de plusieurs paramètres:

- La technologie supportant cette customisation
- Le respect d'une méthodologie de développement conseillée par l'éditeur
- La gestion de configuration de l'environnement applicatif PLM

## L'ergonomie est importante

Sur ce point il y a différentes écoles. Je me rappelle de mon poste de consultant SAP où de nombreuses personnes souvent nouvelles au système, critiquaient son ergonomie et au contraire, les personnes qui avaient pris l'habitude de la solution, qui depuis était figé, trouvaient l'interface simple et connaissaient les raccourcis adaptés à leur utilisation. Pour le PLM, j'ai côtoyé principalement des utilisateurs de PTC Windchill et d'Aras Innovator ces dernières années. Il y a entre ces solutions deux approches très différentes. La première (Windchill) propose à l'utilisateur une ergonomie de base avec une forte capacité d'adaptation de l'interface (onglets et organisation personnalisable). La seconde (Innovator) présente une solution plus figée pour les utilisateurs, très customisable lors de l'implémentation mais peu personnalisable une fois en production. J'ai eu des retours plus ou moins bon pour les deux types d'interface, et en général, plus les personnes utilisaient le système plus elles s'y adaptaient avec une courbe d'apprentissage plus courte pour Aras mais une personnalisation plus forte sur Windchill. Donc là dessus, passez à l'item suivant et demandez des retours d’expérience!

## Demandez des références

Demander des références est primordial mais cela a deux risques qu'il faut mesurer. Le premier est celui des intégrateurs jeunes ou des solutions techniques jeunes, en général les références sont limitées et peuvent être géographiquement éloignées, si vous pensez que de nouvelles solutions peuvent avoir un avantage technique, faites le déplacement! Le second risque est de se retrouver avec un lot de références sélectionnées et briefés. Pour compenser cela, vous pouvez intégrer des groupes associatifs tels que le [PLMLab](http://plmlab.fr/) (un peu de pub) dans lesquels la parole est assez libre autant en bien qu'en mal sur des technologies, des pratiques, des expériences,...

## Mesurez tout

Ici on rentre dans des choses qui paraissent compliquées à grande échelle et qui pourtant lorsque cela est découpé en petits morceaux peuvent être réalisées. Le temps de validation d'un workflow, le nombre de pièces utilisées, la vitesse de réponse à un appel d'offre, ... autant d'indicateurs qu'il faut mettre en place avant l'implémentation de chaque bloc, pour pouvoir mesurer les apports d'une solution technique. Dans les faits, très peu de métriques sont mis en place car la démarche PLM vient remettre en cause des processus fonctionnels qui rendent compliqués la comparaison avec le passé.

## Ne remettez pas ce projet à plus tard

C'est une question de compétition. Une démarche PLM complète n'est pas forcément la priorité numéro 1 pour toutes les entreprises. Je ne serai pas aussi critique que zero wait state. Mais pour le bien de l'industrie PLM... Oui ne remettez pas ce projet à plus tard ! ;)

Retrouvez l'article de zero wait state : [http://zerowait-state.com/the-plm-state-top-7-for-selecting-and-implementing-plm/](http://zerowait-state.com/the-plm-state-top-7-for-selecting-and-implementing-plm/)
