---
title: "l'ESB pour centraliser les services PLM et inter-domaines"
date: 2015-06-30
categories: 
  - "plm"
  - "techniques_logicielles"
coverImage: "esb.png"
---

J'ai déjà écrit plusieurs fois sur les architectures idéales qui devraient être mises en place pour faciliter l'intégration des solutions PLM avec le reste des applications d'entreprise et surtout pour changer le point de vue des responsables IT en partant toujours de la spécification d'un service fonctionnel (créer un article, créer une version,... ) pour ensuite comprendre ce que cela implique et ce qui, potentiellement, serait distribué à travers plusieurs applications (nouvelle référence dans l'ERP, circuit de validation aux achats,...). Lors du dernier PLMLab, au déjeuner j'ai pu discuter avec un industriel qui à ma grande surprise avait déjà une démarche très poussée dans ce sens avec une plateforme SOA qui permettait de gérer ses services et qui était le vrai socle principal de leur stratégie IT général (intégrant autant l'ERP, que le PLM, le CRM,...). L’expérience de cet industriel semblant être concluante j'en profite pour faire un rappel de ce qu'est l'ESB et du panorama des solutions disponibles.

## Enterprise Service Bus

L'Enterprise Service Bus, Bus de services de l'entreprise a pour tâche principal d'orchestrer les services de l'entreprise et de les diriger ou "router" pour s'assurér que les bonnes fonctions soient appelées et les bonnes données crées.

Wikipedia (sur sa page anglophone, répertorie les caractéristiques élémentaires d'un ESB:

| Invocation | support for synchronous and asynchronous transport protocols, service mapping (locating and binding) |
| --- | --- |
| Routing | addressability, static/deterministic routing, content-based routing, rules-based routing, policy-based routing |
| [Mediation](https://en.wikipedia.org/wiki/Data_mediation "Data mediation") | adapters, protocol transformation, service mapping |
| Messaging | message-processing, message transformation and message enhancement |
| [Process choreography](https://en.wikipedia.org/wiki/Process_choreography "Process choreography") | implementation of complex business processes |
| [Service orchestration](https://en.wikipedia.org/wiki/Orchestration_\(computers\) "Orchestration (computers)") | coordination of multiple implementation services exposed as a single, aggregate service |
| [Complex event processing](https://en.wikipedia.org/wiki/Complex_event_processing "Complex event processing") | event-interpretation, correlation, pattern-matching |
| Other [quality of service](https://en.wikipedia.org/wiki/Quality_of_service "Quality of service") | security (encryption and signing), reliable delivery, transaction management |
| [Management](https://en.wikipedia.org/wiki/Systems_management "Systems management") | monitoring, audit, logging, metering, admin console, [BAM](https://en.wikipedia.org/wiki/Business_Activity_Monitoring "Business Activity Monitoring") (BAM is not a management capability in other words the ESB doesn’t react to a specific threshold. It is a business service capability surfaced to end users. ) |
| [Agnosticism](https://en.wikipedia.org/wiki/Agnosticism "Agnosticism") | general agnosticism to operating-systems and programming-languages; for example, it should enable interoperability between [Java](https://en.wikipedia.org/wiki/Java_\(programming_language\) "Java (programming language)") and [.NET](https://en.wikipedia.org/wiki/Microsoft_.NET "Microsoft .NET") applications |
| [Protocol Conversion](https://en.wikipedia.org/w/index.php?title=Protocol_Conversion&action=edit&redlink=1 "Protocol Conversion (page does not exist)") | comprehensive support for topical communication protocols service standards |
| [Message Exchange Patterns](https://en.wikipedia.org/wiki/Message_Exchange_Pattern "Message Exchange Pattern") | support for various MEPs ([Message Exchange Patterns](https://en.wikipedia.org/wiki/Message_Exchange_Pattern "Message Exchange Pattern")) (for example: synchronous request/response, asynchronous request/response, send-and-forget, publish/subscribe) |
| Adapters | adapters for supporting integration with legacy systems, possibly based on standards such as [JCA](https://en.wikipedia.org/wiki/J2EE_Connector_Architecture "J2EE Connector Architecture") |
| Security | a standardized security-model to authorize, authenticate and audit use of the ESB |
| Transformation | [facilitation of the transformation](https://en.wikipedia.org/wiki/Middleware_Analysts "Middleware Analysts") of data formats and values, including transformation services (often via [XSLT](https://en.wikipedia.org/wiki/XSL_Transformations "XSL Transformations") or [XQuery](https://en.wikipedia.org/wiki/XQuery "XQuery")) between the formats of the sending application and the receiving application |
| Validation | validation against schemas for sending and receiving messages |
| [Governance](https://en.wikipedia.org/wiki/SOA_Governance "SOA Governance") | the ability to apply business rules uniformly |
| Enrichment | [enriching messages](https://en.wikipedia.org/wiki/Event-driven_SOA "Event-driven SOA") from other sources |
| Split and Merge | the splitting and combining of multiple messages and the handling of exceptions |
| Abstraction | the provision of a unified abstraction across multiple layers |
| Routing and Transformation | routing or transforming messages conditionally, based on a non-centralized policy (without the need for a central rules-engine) |
| Commodity Services | provisioning of commonly used functionality as shared services depending on context |

Toutes ces caractéristiques révèlent une plateforme logistique de l'information d'entreprise permettant de faire en sorte que les différentes applications communiquent entre elles tout en maîtrisant  une logique et une sécurité centralisée à la différence de simples intégrations point à point que l'on pourrait réaliser avec un simple ETL.

\[caption id="" align="alignnone" width="550"\]![](images/ESB_Component_Hive.png) "[ESB Component Hive](https://commons.wikimedia.org/wiki/File:ESB_Component_Hive.png#/media/File:ESB_Component_Hive.png)" by [Axelangeli](//commons.wikimedia.org/wiki/User:Axelangeli "User:Axelangeli") - Own work. Licensed under [CC BY 3.0](http://creativecommons.org/licenses/by/3.0 "Creative Commons Attribution 3.0") via [Wikimedia Commons](https://commons.wikimedia.org/wiki/).\[/caption\]

## Le panorama des solutions (sources wikippedia)

### Commercial

- [Talend Enterprise ESB](https://en.wikipedia.org/wiki/Talend "Talend")
- [SAP Process Integration](https://en.wikipedia.org/wiki/SAP_Process_Integration "SAP Process Integration")
- [Adeptia](https://en.wikipedia.org/wiki/Adeptia "Adeptia") ESB Suite
- [webmethods Enterprise Service Bus](https://en.wikipedia.org/wiki/WebMethods "WebMethods") (SoftwareAG)
- [(TIBCO) ActiveMatrix™ BusinessWorks](https://en.wikipedia.org/wiki/TIBCO_Software "TIBCO Software")
- [IBM Integration Bus](https://en.wikipedia.org/wiki/IBM_WebSphere_Message_Broker "IBM WebSphere Message Broker")
- [IBM WebSphere ESB](https://en.wikipedia.org/wiki/IBM_WebSphere_ESB "IBM WebSphere ESB")
- [Microsoft BizTalk Server](https://en.wikipedia.org/wiki/Microsoft_BizTalk_Server "Microsoft BizTalk Server")
- [Neudesic Neuron ESB](https://en.wikipedia.org/wiki/Neudesic "Neudesic")
- [Windows Azure Service Bus](https://en.wikipedia.org/wiki/Windows_Azure "Windows Azure")
- [Oracle Enterprise Service Bus](https://en.wikipedia.org/wiki/Oracle_Enterprise_Service_Bus "Oracle Enterprise Service Bus") (BEA Logic)
- [Progress Sonic ESB](https://en.wikipedia.org/wiki/Progress_Software "Progress Software") (acquired by [Trilogy](https://en.wikipedia.org/wiki/Trilogy_\(company\) "Trilogy (company)"))
- [Red Hat JBoss Fuse](https://en.wikipedia.org/wiki/Fuse_ESB "Fuse ESB"), originally Fuse ESB from [IONA Technologies](https://en.wikipedia.org/wiki/IONA_Technologies "IONA Technologies") (later acquired by [Progress Software](https://en.wikipedia.org/wiki/Progress_Software "Progress Software"))
- [InterSystems Ensemble](https://en.wikipedia.org/wiki/InterSystems "InterSystems")
- [Mule ESB (Enterprise Edition)](https://en.wikipedia.org/wiki/Mule_ESB "Mule ESB")

### Open-source

- [Apache Camel](https://en.wikipedia.org/wiki/Apache_Camel "Apache Camel")
- [Apache ServiceMix](https://en.wikipedia.org/wiki/Apache_ServiceMix "Apache ServiceMix")
- [Apache Synapse](https://en.wikipedia.org/wiki/Apache_Synapse "Apache Synapse")
- [Talend Open Studio for ESB](https://en.wikipedia.org/wiki/Talend "Talend")
- [JBoss ESB](https://en.wikipedia.org/wiki/JBoss_Enterprise_SOA_Platform#Enterprise_Service_Bus_.28ESB.29 "JBoss Enterprise SOA Platform")
- [NetKernel](https://en.wikipedia.org/wiki/NetKernel "NetKernel")
- [Petals ESB](https://en.wikipedia.org/wiki/Petals_ESB "Petals ESB")
- [Spring Integration](https://en.wikipedia.org/wiki/Spring_Integration "Spring Integration")
- [Open ESB](https://en.wikipedia.org/wiki/Open_ESB "Open ESB")
- [WSO2 ESB](https://en.wikipedia.org/wiki/WSO2_ESB "WSO2 ESB")
- [Mule ESB (Community Edition)](https://en.wikipedia.org/wiki/Mule_ESB "Mule ESB")
- [UltraESB](https://en.wikipedia.org/wiki/UltraESB "UltraESB")
- [Red Hat Fuse ESB](https://en.wikipedia.org/wiki/Fuse_ESB "Fuse ESB") (based on Apache Camel)

## Conclusion

Le but n'est pas de faire un cours sur l'ESB, il est plus de sensibiliser la sphère PLM qui ne le serait pas encore à ces problématiques d'intégration qui dépassent très largement la gestion de cycle de vie du produit mais qui sont essentielles à la réussite de projets PLM. C'est un socle primordial pour les futures implémentations PLM dans les entreprises. **Donc si vous débutez un projet PLM sans savoir ce qu'est un ESB, vous avez sauté une étape !**
