---
title: "[Standards] PDX - échange de données de fabrication dans l'industrie électronique"
date: 2015-05-20
categories: 
  - "plm"
  - "standards"
coverImage: "pdx.png"
---

Dans le panorama des standards de données, étant ingénieur en électronique de formation (Ingénieur ESIEE 2006), il fallait que je m'intéresse au format PDX (Product Data eXchange for the supply chain => IPC-2571)

La définition de ce standard est disponible sur [le site de l'IPC.](http://webstds.ipc.org/standards.htm)

[![IPC2571](images/IPC2571.jpg)](http://webstds.ipc.org/standards.htm#x2570)

## IPC-2571, sa place chez IPC ?

J'avais indiqué dans mon dernier article que les standards étaient payants (ou soumis à admission annuelle), alors j'essaye de trouver quelle est la place de celui-ci chez IPC. Je retourne donc au schéma suivant de présentation des standards:

[![standards IPC](images/IPC2571INIPC.jpg)](http://webstds.ipc.org/standards.htm#x2570)

 

Alors pourquoi les standards IPC25XX sont-ils diffusés? J'avoue que même à la lecture de leur site, je n'ai pas encore de réponse. J'ai envoyé un email au responsable de cette partie pour en savoir plus, sa première réponse n'a pas été très claire et je mettrai à jour cet article si un nouveau retour vient répondre de manière plus précise.

En tout cas, on comprend que l'on est ici sur une problématique d'interface et donc de partage de l'information. C'est donc une première question que je me pose. Pourquoi définir un standard de "contenu" et un standard d'interface? Cela pourrait être pour définir des "Blob" spécifiques au partage d'informations entre concepteurs et producteurs. Le problème pourrait-être qu'avec le temps, le découpage des acteurs dans la conception et la production de bien peut évoluer, on l'a vu dans l'automobile. Ainsi ces standards devront surement évoluer, mais il reste que j'ai du mal à expliquer la dissociation.

## IPC-2571, sa place dans le 25XX ?

Au sein des standards d'interfaçage d'industriels du monde électronique, l'IPC-2571 est plus communément appelée PDX et représente un package de métadonnées qui doivent permettre de partager des données de manufacturing, d'achat et d'évolutions. La spécification précise les interactions avec les autres standards compris dans le set de spécifications dédiées aux interface (25XX). Il est ainsi précisé que c'est avec la 2510 que la 2571 va être la plus proche car IPC-2510 décrit les produits à réaliser de manière très technique telle que la réception d'un fichier GenCAM (IPC-2510) doit permettre d'avoir toutes les infos pour potentiellement automatiser la production d'une carte électronique. Alors que la 2571 se retrouve à un niveau au dessus pour ainsi distinguer autant que possible la partie logistique de la partie manufacturing dans la supply chain.

## La structure du PDX

Avant de rentrer plus en détail dans la structure du PDX et sa représentation du produit. Il est très intéressant de noter la présence d'un DTD avec chaque spécification de standard 25XX. Ainsi lorsque vous recevez une structure produit respectant le standard PDX, vous pouvez valider son contenu en utilisant ce DTD et ainsi vous assurer de la qualité des données reçues.

### Le package principal du PDX

Le package est représenté avec le contenu suivant :

[![pdx_general](images/pdx_general.jpg)](http://webstds.ipc.org/standards.htm#x2570)

On remarque déjà entre autres la présence des:

- Items qui vont représenter le contenu du produit et sa nomenclature
- les "Changes" qui vont permettre de communiquer les évolutions d'une version à une autre pour un industriel.
- le AsBuiltProduct qui va en fait permettre d'intégrer les instances produites (ça n'est pas une BOM complémentaire).

### Le contenu d'un Article

Le contenu du Part est le suivant:

[![pdx_part](images/pdx_part.jpg)](http://webstds.ipc.org/standards.htm#x2570)

 

Alors cette vue est assez simple en termes de modèle de données. Un Item (comprendre un Article), contient:

- des propriétés "systèmes" et opérationnelles (premier encadré). Je suis étonné d'éléments d'identité (OwnerName) de type string alors que le PDX contient un objet contact qui pourrait jouer le rôle d'identifiant.
- Une nomenclature (BillOfMaterial) qui contient la liste des sous-composants représenté en tant que référence. Il faut retrouver cette référence sur la liste principale des items pour poursuivre la navigation de la BOM. Cependant il suffit d'une interface plus adaptée pour potentiellement représenter la nomenclature complète.

[![PDX_structureBOM](images/PDX_structureBOM.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/05/PDX_structureBOM.jpg)

 

- Il est ensuite possible de lister les évolutions de l'article, ces articles alternatifs, qui là encore seront listés en tant qu'item.

### La flexibilité de PDX sur les diffusions selectives

PDX prend bien en compte le fait que dans un produit, il peut y avoir plusieurs sous ensembles fabriqués par des industriels différents qui ne doivent pas accéder aux informations de manufacturing des autres éléments. Le schéma PDX reste donc valide avec cela, il suffit d'avoir un générateur de PDX qui limite les données intégrées dans le package selon le destinataire.

## Conclusion

Au final il faut vraiment voir PDX comme un format de transmission de données sans vraiment d'aller-retour entre deux entités. Il répond à un besoin clair: Permettre à des concepteurs de fournir de manière informatisée et dans un format largement utilisé, des données sur un produit ou un sous-produit afin qu'un industriel réalise le bien en question. Il prend en compte le côté dynamique itératif qui amène le concepteur a faire évoluer son produit et donc à communiquer les deltas impactant le manufacturing.

On est donc loin d'un standard vraiment utile de description "universelle" de structures produits qui vivent. On voit bien ici, qu'une fois le package réalisé et envoyé à l'industriel, ce package n'est valide que jusqu'au prochain export.

La prochaine étude sera sur un standard de travail plus que sur un standard d'échange. N'hésitez pas à partager toute expérience sur un standard de ce type, ou à simplement indiqué si vous connaissiez le format PDX.
