---
title: "[Standards] Mon plongeon dans les standards PLM"
date: 2015-04-27
categories: 
  - "plm"
  - "standards"
coverImage: "plmstandards.jpg"
---

Comme je l'ai indiqué dans mon article du 7 avril 2015, je débute donc une série d'articles sur les standards dans le PLM. Leur titre commencera toujours par \[Standards\] afin de bien les identifier comme ils seront intercalés avec d'autres articles. Lors de mes 5 dernières années dans le monde du PLM j'avoue ne pas avoir investi énormément de temps à l'étude des standards, et ce pour plusieurs raisons:

- Ils sont à priori très orientés CAO (on est majoritairement dans l'échange de modèles CAO)
- Il y a les standards de facto et les "vrais" standards créés dans le cadre d'organismes de standardisation, pas simple de faire le tri.
- Quand on est consultant, l'applicabilité difficile des standards peut être un frein
- manque de Temps ! (5 années intensives de PLM et de diverses gestion de données !)

Alors que je suis en quelque sorte dans une transition, ou tout du moins, dans une évolution de mon travail dépassant le scope du PLM avec de plus en plus d'activités de gestion de données, gestion de référentiels, intégration de systèmes variés, la question des standards me revient souvent à l'esprit lorsque j'entends les besoins de nos clients.

## Pourquoi les standards

Et oui ! Pourquoi les standards, puisque mon entreprise ne produit pas les même chose que l'entreprise voisine? Pourquoi devrait-on avoir les même méthodes de travail? Des chargeurs de téléphones aux modèles CAO, de la couleur des feux de circulation aux documents de gestion des modifications, le besoin de standardisation a toujours des éléments en commun. Sans avoir pour prétention de définir les standards, je vous propose d'abord l'explication des bénéfices des standards par l'ISO:

> Use of the standards ensures that products and services are safe, reliable and of good quality. The standards help businesses increase productivity while minimising errors and waste. By enabling products from different markets to be directly compared, they facilitate companies in entering new markets and assist in the development of global trade on a fair basis. The standards also serve to safeguard consumers and the end-users of products and services, ensuring that certified products conform to the minimum standards set internationally.

Une autre description proposé par [IPC (association de standardisation dans l'industrie électronique)](http://www.ipc.org/default.aspx) présente ce que doivent, et ne doivent pas être les standards dans l'intérêt général.

Les standards devraient:

> - Show relationship to Design for Manufacturability (DFM) and Design for the Environment (DFE)
> - Minimize time to market
> - Contain simple (simplified) language
> - Just include spec information
> - Focus on end product performance
> - Include a feedback system on use and problems for future improvement

Les standards ne devraient pas:

> - Inhibit innovation
> - Increase time-to-market
> - Keep people out
> - Increase cycle time
> - Tell you how to make something
> - Contain anything that cannot be defended with data

## La gestion de données au centre de mon métier

Mon expérience personnelle autour des standards tourne très largement autour de la récupération de données, et l'échange de données entre systèmes logiciels différents. Je ne compte plus les nomenclatures que l'on me fournit sous format Excel pour les importer dans une solution PLM avec toujours la même phrase: "ça devrait être simple c'est un format assez standard". (Je ne suis d'ailleurs pas étonné de voir que l'article le plus consulté sur ce blog soit ["La ptite macro Excel du Dimanche pour reconstruire une nomenclature"](http://plm-ouvert.fr/2013/10/la-ptite-macro-excel-du-dimanche-pour-reconstruire-une-nomenclature/)).

## La démarche

La démarche que je lance va avoir différents objectifs.

- Partager des recherches et réflexions sur les standards du PLM: C'est le format supporté par ce blog, je vais, à travers mes articles vous faire part de mon avancement sur l'étude et les réflexions autour des standards du PLM.
- Réaliser des livres blancs orientés IT sur les standards du PLM
- Réaliser des mini maquettes, le but n'était pas d'avoir des plateformes de conversions de standards, mais plus des petits démonstrateurs techniques pour illustrer la démarche.

Pour démarrer sur le sujet, je vais travailler sur la BOM en partant de quelque chose de simple pour voir ensuite pourquoi cela se complexifie et comprendre s'il n'y a pas un dénominateur commun qui pourrait être intéressant.

### En complément du PLMLab

[![StandardsPLMLAB1](images/StandardsPLMLAB1.jpg)](http://www.plmlab.fr/index.php?page=documents)Le PLMLab avait débuté un vrai travail de fond sur le sujet avec la parution d'un guides. Ce guide très complet et abordable offre une très bonne présentation des standards dans le PLM.

Ma démarche n'est pas une recopie de celle du PLM, j'ai pour but d'aller vraiment dans l'étude de ce qui peut-être implémenté. Comment faire en sorte que mes interlocuteurs, quelque soit leur taille, puisse avoir une démarche intégrant les standards.

### Invitations

Dans ces différents articles j'inviterai chacun à commenter les propositions ou les questions que je poserai dans le but d'alimenter en expériences industrielles ce long chemin que je m’apprête à prendre.
