---
title: "Comparer les systèmes par fonction PLM pour favoriser l'essort de nouvelles solutions"
date: 2015-04-07
categories: 
  - "plm"
  - "solutions-logicielles"
  - "techniques_logicielles"
coverImage: "plmstore.jpg"
---

Lorsque l'on part à la recherche d'une solution PLM, on cherche généralement un éditeur qui va, dans un même logiciel, nous permettre de faire un maximum de choses autour de la conception, de l'ingénierie, sans avoir à exporter et importer des données d'un logiciel à un autre. Plus on est en attente d'un grand nombre de fonctionnalités, plus on va réduire le panel de sélection. Plus on va être centré autour de la CAO avec un fort intérêt pour la CAO, plus on va encore une fois restreindre sa sélection aux éditeurs historiques de CAO.

## Explorer la connaissance métier d'éditeurs autres que PLM

Le PLM s'est démarqué du PDM sur deux axes:

- L'ajout de fonctionnalités métiers (Gestion de configuration, gestion qualité, gestion de projet, gestion de programmes, gestion fournisseurs,...)
- La mise à disposition d'une boite à outils (framework) pour élargir la quantité d'applications.

Concernant les fonctionnalités, une fois qu'elles étaient intégrées au PLM, on réduisait alors la sélection aux éditeurs de PLM. Si on prend la gestion de projet, lorsqu'une personne est à la recherche d'une solution PLM, le besoin d'une gestion de projet intégrée au PLM va être très fort. Et si les fonctionnalités de base sont là et que c'est intégré au PLM, la sélection va aller largement en faveur d'une solution intégrée sans avoir à évaluer les solutions d'autres éditeurs.

Le problème est qu'on laisse de côté un grand nombre d'éditeurs avec des solutions innovantes et une compréhension de spécialiste sur des problématiques métiers spécifiques. Alors, quels sont les freins à cette recherche d'acteurs alternatifs? Comment faire en sorte qu'il y en ait plus qui intègrent le panorama du PLM?

### Quelques exemples d'éditeurs non-PLM qui pourtant intègrent des fonctions que l'on pourrait voir dans un PLM

Je suis preneur de toute recommandation pour enrichir la liste et je l’intégrerai dans une page indépendante si elle devient trop importante.

- AMDEC
    - [http://www.byteworx.com/](http://www.byteworx.com/)
    - [http://www.reliasoft.com/xfmea/features1.htm](http://www.reliasoft.com/xfmea/features1.htm)
    - [http://www.fmea.co.uk/FMEA\_software.html](http://www.fmea.co.uk/FMEA_software.html)
- Gestion des exigences
    - [http://makingofsoftware.com/resources/list-of-rm-tools](http://makingofsoftware.com/resources/list-of-rm-tools)
- Gestion de projet
    - [http://en.wikipedia.org/wiki/Comparison\_of\_project\_management\_software](http://en.wikipedia.org/wiki/Comparison_of_project_management_software)
- ...

## Les standards encore les standards...

Un premier niveau est bien sûr les standards. S'ils y avait une utilisation plus large des standards et peut-être une énième remise en question de ceux-ci pour passer à un niveau technique plus qu'à un niveau métiers, on permettrait à plus d'éditeur de gagner en temps de développement et de permettre de s'intégrer plus facilement dans les environnements applicatifs des entreprises. On comprend ici une des raisons pour laquelle les éditeurs de PLM ne seront pas moteurs.

## La mise en place de plateformes MDM/ESB

La mise en place d'une couche de gestion de données transverse à l'entreprise sera un élément de plus pour contribuer à faciliter l'accès à de nouveaux éditeurs. On voit d'ailleurs dans un grand nombre d'applications distribuées en SaaS que les éditeurs publient leurs services en tant qu'API. Ce qui veut dire qu'ils peuvent clairement dissocier services web et interfaces. Je pense que ces éditeurs ont une plus grande agilité pour s'adapter à un environnement dans lequel les entreprises demanderaient que le point d'entrée soit un ESB ou un MDM.

## L'app-store du PLM?

Oui, c'est en effet la tendance et le but. Permettre de mettre en place une couche technique qui favorise la création d'app-stores du PLM avec une forte capacité d'échanges d'informations entre les applications utilisées. L'exemple le plus récente que j'ai pu voir en termes d'applications d'entreprise, c'est la plateforme zoho que nous utilisons chez Minerva pour son CRM et qui propose un grand nombre d'applications complémentaires avec une forte interaction entre chacune.

## Favoriser un écosystème d'éditeurs en réduisant le ticket d'entrée

Le but de tout cela, est clairement de permettre aux utilisateurs finaux d'avoir de meilleures applications à un coût inférieur en faisant jouer la concurrence et en poussant les spécialistes à se restreindre à leur domaine (les architectes sur l'architectures IT et les spécialistes métiers sur des fonctionnalités métiers sans avoir à se soucier de l'IT). Donc cette démarche ne peut venir aujourd'hui que des clients finaux qui doivent permettre l'approche d'éditeurs en abaissant le ticket d'entrée pour ceux-ci. Aujourd'hui un éditeur peine à intégrer le marché du PLM s'il n'a pas de CAO (alors qu'il propose peut-être simplement de l'analyse AMDEC, ou de la gestion d'exigences)

Pour poursuivre cette étude, je vais, au cours des prochains articles, aborder les deux axes présentés ici:

- Comment mettre en place des solutions MDM/ESB simplement dans les entreprises?
- Etudier les standards sur différents niveaux, IT et PLM.
