---
title: "ETL - Extract Transform Load : L'exemple Talend pour alimenter Aras Innovator"
date: 2015-03-23
categories: 
  - "plm"
  - "techniques_logicielles"
coverImage: "ETL_Talend.png"
---

## Le projet de Migration dans un contexte PLM

Chaque projet d'implémentation d'une solution logicielle dans un contexte PLM comprend une part de migration de données. Vous pouvez même être une jeune startup, vous aurez toujours au moins quelques données à importer, et dans le cas où vous basculez d'une solution "PLM" existante vers une autre, vous avez de grandes chances de devoir mettre en place un important projet de migration de données.

Dans la quantité de données à migrer il y a deux types de données pour lesquelles il est important de se poser la question du format d'export:

- Les données statiques: cette dénomination ne veut pas dire que ces données n'évoluent pas. Elles ont surtout pour but de décrire un item, décrire son état, ses propriétés. Ces données sont celles qui sont susceptibles de changer le moins possible.
- Les données dynamiques: Dans ce cas je parle des informations qui vont décrire des processus qui ont été réalisés. On va retrouver beaucoup de données d'historique ("Michel Dupont a validé cette étape de workflow à 16h39,..."). Ces données en général implémentent de nombreux liens (utilisateurs, objet concerné,...). Et il est donc pertinent de se poser la question du besoin de les migrer en l'état.

Les projets de migration peuvent être assez compliqués à dimensionner et demandent en général un audit qui va évaluer les axes suivants:

- Volume de données à migrer (avec filtre sur la pertinence du besoin de migrer certaines données)
- Capacité d'extraction des systèmes sources (quels sont les moyens mis à disposition pour récupérer les données et quelles sont les ressources nécessaires pour réaliser cette extraction?)
- Quantité de type d'objets
- Qualité de données
- Effort de transformation des données pour les amener d'un système A à un système B  (ou de N vers 1 système, 1 vers N ou N vers N)
- Capacité de chargement des systèmes cibles (quels sont les moyens mis à disposition pour charger les données et quelles sont les ressources nécessaires pour réaliser ce chargement?)

##  ETL l'outil indispensable

Je ne suis pas développeur de formation et tout le temps que je pourrai gagner en évitant de faire du code, je le prends. Alors je me renseigne sur les outils qui font à peu près ce qui m'intéresse ,c'est à dire:

- Extraire des données depuis des systèmes divers (logiciels, fichiers, bases de données, webservices)
- Les transformer et joindre certaines données
- Les recharger dans le ou les systèmes cibles.

Et en quelques recherches je comprends que l'ETL est ce que je recherche. Et s'il y a un outil qui est rapidement accessible en téléchargement et simple à prendre en main c'est la solution d'intégration de données de la société Talend ( par souci d’honnêteté, je précise que lors de l'écriture de cet article, je travaille au sein de [la société Minerva France](http://minerva-plm.fr/aras/accueil/) qui depuis moins d'un an est partenaire intégrateur de la solution Talend. Cependant, mon expérience avec Talend a bien été initiée par la recherche d'un ETL téléchargeable gratuitement, et ce, en 2010).

Ce n'est pas la seule solution disponible. Et en jetant un simple coup d’œil à wikipedia, vous pouvez avoir une liste assez importante de solutions existantes. Au 17/03/2015 wikipedia liste les éléments suivants :

- SnapLogic
- Alteryx
- Informatica PowerCenter
- IBM Datastage
- Ab Initio
- Microstrategy
- Oracle Data Integrator (ODI)
- Microsoft SQL Server Integration Services (SSIS)
- Pentaho Data Integration (or Kettle)
- Talend
- FlyData
- Rhino ETL
- SAP Data Services
- Clover ETL /opensource engine supporting only basic partial functionality and not server/

Il existe plusieurs solutions et il sera sûrement judicieux dans certains cas de prendre ce qui est déjà à votre disposition. Lors de projets d'intégration j'ai été frappé par le fait que ces solutions sont encore très peu répandues pour supporter des stratégies d'intégration de données dans un contexte PLM. Pour présenter un court exemple de migration de données simples vers la solution Aras Innovator en utilisant Talend, vous trouverez ci-dessous une vidéo:

## Vidéo : Démonstration de chargement simple d'articles pour Aras Innovator

https://www.youtube.com/embed/eRGJLA5uNvU

Cette vidéo présente l'outil dans un contexte très simple. Je présenterai dans d'autres articles des exemples plus complexes de migration ou d'intégration réalisées à l'aide d'un ETL.
