---
title: "Neo4J - pourquoi une base de données graphique facilite la gestion des accès pour le PLM"
date: 2014-07-28
categories: 
  - "bdd"
  - "plm"
coverImage: "blog_neo4j.png"
---

Afin de comprendre comment les dernières nouveautés technologiques peuvent aider mes clients dans leurs démarches PLM, je teste pas mal de technologies. Sans être un spécialiste d'un langage en particulier j'aime bien toucher à différentes technologies ou au moins essayer de comprendre les avantages et inconvénients de chacun appliqué à un contexte PLM. Depuis quelques temps, je suis le monde des bases de données et j'essaye de comprendre si les innovations récentes largement dans le monde du NoSQL peuvent être un réel plus pour les solutions PLM. Et la problématique a souvent deux axes principaux d'études: 1) l'évolution technique apportera-t'elle un plus en termes de performance et 2) est-ce que cette technologie va apporter à l'entreprise ou à l'éditeur de la solution PLM plus de flexibilité. Le côté performance n'est pas ma spécialité et je voulais illustrer le côté flexibilité avec [Neo4J](http://www.neo4j.org/) en présentant le cas d'implémentation d'un jeu de permission d'accès à un article dans une solution PLM.

La gestion des permissions est quelque chose de compliqué habituellement dans une solution PLM car cela peut demander un grand nombre de JOIN en SQL pour aller savoir si vous avez accès en écriture sur un objet. Potentiellement le lien entre vous et l'objet sera composé d'un objet User 3 ou 4 Groupes, d'un objet de permission et au final l'objet article. Avec entre chacun, des tables de correspondance en plus.

J'ai voulu représenter la configuration suivante:

[![blog](images/blog.png)](http://plm-ouvert.fr/wp-content/uploads/2014/07/blog.png)

 

La première étape consiste donc à rentrer cette structure dans la base graphique à l'aide du [langage Cypher](http://docs.neo4j.org/refcard/2.1/).

CREATE (a:User {name:"Yoann"}),(b:User {name:"Henri"}),(c:User {name:"Michel"}),(d:User {name:"Jeanne"}),(e:Identity {name:"Engineering"}),(f:Identity {name:"Proto Purchasing"}),(g:Identity {name:"Purchasing"}),(h:Permission {name:"PartAccess"}),(i:Part {name:"NewCar X999",partNumber:"X999"}),(a)-\[:isPartOf\]->(e),(b)-\[:isPartOf\]->(e),(c)-\[:isPartOf\]->(f),(d)-\[:isPartOf\]->(g),(g)-\[:isPartOf\]->(f),(e)-\[:canUpdate\]->(h),(f)-\[:canRead\]->(h),(h)-\[:definesAccessTo\]->(i)

Chaque item (noeud) peut contenir des paramètres fournis sous forme de Json. Ici nous n'avons fourni que le name pour les users, identitées et les permissions, l'article se voit rajouter un part number.

[![resultcypher1](images/resultcypher1.jpg)](http://plm-ouvert.fr/wp-content/uploads/2014/07/resultcypher1.jpg)

A partir de là, ma structure est mise en place et je voulais évaluer la facilité à retrouver sur l'article X999 les personnes qui ont un accès en écriture ou en lecture.

Toujours avec le langage de requête cypher je pouvais avoir la liste des personnes qui ont le droit d'écriture avec la requête suivante:

MATCH (a:User)-\[:isPartOf\*\]->(b:Identity)-\[:canUpdate\]->(c:Permission)-\[:definesAccessTo\]->(d:Part) WHERE d.partNumber="X999" RETURN a

Et la liste des personnes pouvant juste avoir accès en lecture:

MATCH (a:User)-\[:isPartOf\*\]->(b:Identity)-\[:canRead\]->(c:Permission)-\[:definesAccessTo\]->(d:Part) WHERE d.partNumber="X999" RETURN a

Le résultat pour les droits de lecture est : Michel et Jeanne bien qu'ils soient à des distances différentes de l'article.

[![resultcypher2](images/resultcypher2.jpg)](http://plm-ouvert.fr/wp-content/uploads/2014/07/resultcypher2.jpg)

En installant [Neo4J](http://www.neo4j.org/learn/try) vous pouvez très rapidement jouer ces trois requêtes.

Est-ce la meilleur façon de le modéliser? Je ne suis pas sûr. Vaut-il mieux stocker le type d'accès sur la variable d'une relation? possible. Tout ce que je voulais montrer ici c'est qu'en quelques minutes j'avais réussi à mettre en place un système intégrant des objets d'identité et un article, et de rendre fonctionnel une solution de gestion des permissions. C'est pour des cas d'emploi comme celui-ci que l'on se rend compte que ce type de base de données peut apporter beaucoup d'agilité pour le domaine du PLM.

Ajout du 28/07/2014

Maintenant je me dis que dans une solution PLM, je veux que tout le contenu suive ces règles d'accès. Donc en général ma première problématique n'est pas qui peut voir l'objet X mais plutôt quels sont les objets que la personne Y peut voir. Aucun problème, il me suffit juste de modifier légèrement ma requête qui devient alors la suivante:

MATCH (a:User)-\[:isPartOf\*\]->(b:Identity)-\[:canUpdate\]->(c:Permission)-\[:definesAccessTo\]->(d:Part) WHERE a.name="Henri" RETURN d

Dans cette requête je demande la liste des "Part" pour lesquels Henri a un accès en écriture ("canUpdate") !

\[subscribe2\]
